import Component from '../component';
import Swiper from 'swiper';

export default class SwiperSlider extends Component {

	/**
	 * Инициализируем свайпер
	 * @param {object} props параметры свайпера
	 */
	constructor( props = {
		selector: '.swiper-container',
		options: {
			spaceBetween: 10,
		
			// If we need pagination
			pagination: {
			  el: '.swiper-pagination',
			},
		
			// Navigation arrows
			navigation: {
			  nextEl: '.swiper-button-next',
			  prevEl: '.swiper-button-prev',
			},
		
			// And if we need scrollbar
			scrollbar: {
			  el: '.swiper-scrollbar',
			},
		}
	} ){
		super( props );

		this.loadData();
	}

	/**
	 * загружаем данные
	 */
	loadData = () => {

		fetch( 'https://moscowseasons.com/graphql', {
			method: 'POST',
			headers: { 'Content-Type': 'application/json' },
			body: JSON.stringify({
				'operationName': 'albums',
				'variables': {
					'after': null,
					'before': null,
					'first': 10,
					'last': null,
					'locale': 'RU'
				},
				'query': 
					`query albums($locale: Locale, $after: String, $first: Int, $before: String, $last: Int) {
						albums(locale: $locale, after: $after, first: $first, before: $before, last: $last) {
							edges {
								node {
									id
									title
									photos {
										id
										url
										resized(width: 1200, height: 800) {
											url
											__typename
										}
										__typename
									}
									count
									__typename
								}
								__typename
							}
							pageInfo {
								hasNextPage
								startCursor
								endCursor
								__typename
							}
							__typename
						}
					}`
			})
		})
		.then( ( response ) => {
			return response.json();
		})
		.then( ( data ) => {

			let slides = [];

			data.data.albums.edges.forEach( ( album, index ) => {

				const slide = `<div class="swiper-item">
					<h3>Swiper ${index}</h3>
					<p>Swiper ${index} slide</p>
					<img src="${album.node.photos[0].resized.url}" alt="${album.node.title}" />
				</div>`;

				slides[index] = slide;
				
			});

			console.log( slides );

			this.setState({
				slides: slides
			});

		});
	}

	render(){

		// console.log( this.state.slides );

		this.swiper = new Swiper( this.props.selector, this.props.options );
		// this.swiper.appendSlide( this.state.slides );
		console.log( 'Swiper class: render() called' );

	}

}