/**
 * конфиг для разработки
 */

/* global module */
module.exports = {
	mode: 'development',
	entry: {
		app: './src/assets/js/app.js'
	},
	output: {
		filename: '[name].js'
	},
	devtool: 'source-map',
	module: {
		rules: [
			{
				test: /\.js$/,
				exclude: /node_modules/,
				use: {
					loader: 'babel-loader',
					options: {
						presets: [
							[ '@babel/preset-env', {
								useBuiltIns: 'usage'
							} ]
						],
						'plugins': [
							'@babel/plugin-proposal-class-properties',
						]
					}
				}
			}
		]
	}
};