/**
 * Базовый компонент
 */

export default class Component {

	/**
	 * Конструктор
	 */
	constructor( props = {} ){

		/**
		 * Параметры компонента:
		 * scopeSelector - корневой селектор
		 * selectors - селекторы перерисовываемых данных
		 */
		this.props = {
			
		};

		// объединяем с переданными параметрами
		Object.assign( this.props, props );

		// дефолтное состояние
		this.state = {};

		this.setState();
	}


	/**
	 * Установка состояния
	 */
	setState = ( newState = {} ) => {

		console.log( 'Component setState(): Compare states', this.objectEquals( this.state, newState ), this.state, newState );

		if( !this.objectEquals( this.state, newState ) ){
			Object.assign( this.state, newState );
			this.render();
		}
	}


	/**
	 * Сравниваем два объекта
	 */
	objectEquals = (x, y) => {
		if (x === null || x === undefined || y === null || y === undefined) { return x === y; }
		// after this just checking type of one would be enough
		if (x.constructor !== y.constructor) { return false; }
		// if they are functions, they should exactly refer to same one (because of closures)
		if (x instanceof Function) { return x === y; }
		// if they are regexps, they should exactly refer to same one (it is hard to better equality check on current ES)
		if (x instanceof RegExp) { return x === y; }
		if (x === y || x.valueOf() === y.valueOf()) { return true; }
		if (Array.isArray(x) && x.length !== y.length) { return false; }
	
		// if they are dates, they must had equal valueOf
		if (x instanceof Date) { return false; }
	
		// if they are strictly equal, they both need to be object at least
		if (!(x instanceof Object)) { return false; }
		if (!(y instanceof Object)) { return false; }
	
		// recursive object equality check
		var p = Object.keys(x);
		return Object.keys(y).every(function (i) { return p.indexOf(i) !== -1; }) &&
			p.every(function (i) { return objectEquals(x[i], y[i]); });
	}


	/**
	 * обновляем компонент
	 */
	render(){
		return false;
	}
}