/*
 * Decompiled with CFR 0.152.
 */
package com.nuttawutmalee.RCTBluetoothSerial;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.nuttawutmalee.RCTBluetoothSerial.RCTBluetoothSerialService;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class RCTBluetoothSerialModule
extends ReactContextBaseJavaModule
implements ActivityEventListener,
LifecycleEventListener {
    private static final boolean D = true;
    private static final String DEFAULT_SERVICES = "DEFAULT_SERVICES";
    private static final String BT_ENABLED = "bluetoothEnabled";
    private static final String BT_DISABLED = "bluetoothDisabled";
    private static final String CONN_SUCCESS = "connectionSuccess";
    private static final String CONN_FAILED = "connectionFailed";
    private static final String CONN_LOST = "connectionLost";
    private static final String DEVICE_READ = "read";
    private static final String DATA_READ = "data";
    private static final String ERROR = "error";
    private static final int REQUEST_ENABLE_BLUETOOTH = 1;
    private static final int REQUEST_PAIR_DEVICE = 2;
    private static final String FIRST_DEVICE = "firstDevice";
    private BluetoothAdapter mBluetoothAdapter;
    private RCTBluetoothSerialService mBluetoothService;
    private ReactApplicationContext mReactContext;
    private Promise mEnabledPromise;
    private Promise mDeviceDiscoveryPromise;
    private Promise mPairDevicePromise;
    private HashMap<String, Promise> mConnectedPromises;
    private HashMap<String, StringBuffer> mBuffers;
    private HashMap<String, String> mDelimiters;

    public RCTBluetoothSerialModule(ReactApplicationContext reactContext) {
        super(reactContext);
        Log.d((String)"BluetoothSerial", (String)"Bluetooth module started");
        this.mReactContext = reactContext;
        if (this.mBluetoothAdapter == null) {
            this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (this.mBluetoothService == null) {
            this.mBluetoothService = new RCTBluetoothSerialService(this);
        }
        if (this.mConnectedPromises == null) {
            this.mConnectedPromises = new HashMap();
        }
        if (this.mBuffers == null) {
            this.mBuffers = new HashMap();
        }
        if (this.mDelimiters == null) {
            this.mDelimiters = new HashMap();
        }
        if (this.mBluetoothAdapter != null && this.mBluetoothAdapter.isEnabled()) {
            this.sendEvent(BT_ENABLED, null);
        } else {
            this.sendEvent(BT_DISABLED, null);
        }
        this.mReactContext.addActivityEventListener((ActivityEventListener)this);
        this.mReactContext.addLifecycleEventListener((LifecycleEventListener)this);
        this.registerBluetoothStateReceiver();
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put(DEFAULT_SERVICES, Arguments.createArray());
        return constants;
    }

    public String getName() {
        return "RCTBluetoothSerial";
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)"BluetoothSerial", (String)("On activity result request: " + requestCode + ", result: " + resultCode));
        if (requestCode == 1) {
            if (resultCode == -1) {
                Log.d((String)"BluetoothSerial", (String)"User enabled Bluetooth");
                if (this.mEnabledPromise != null) {
                    this.mEnabledPromise.resolve((Object)true);
                    this.mEnabledPromise = null;
                }
            } else {
                Log.d((String)"BluetoothSerial", (String)"User did not enable Bluetooth");
                if (this.mEnabledPromise != null) {
                    this.mEnabledPromise.reject((Throwable)new Exception("User did not enable Bluetooth"));
                    this.mEnabledPromise = null;
                }
            }
        }
        if (requestCode == 2) {
            if (resultCode == -1) {
                Log.d((String)"BluetoothSerial", (String)"Pairing ok");
            } else {
                Log.d((String)"BluetoothSerial", (String)"Pairing failed");
            }
        }
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        Log.d((String)"BluetoothSerial", (String)("On activity result request: " + requestCode + ", result: " + resultCode));
        if (requestCode == 1) {
            if (resultCode == -1) {
                Log.d((String)"BluetoothSerial", (String)"User enabled Bluetooth");
                if (this.mEnabledPromise != null) {
                    this.mEnabledPromise.resolve((Object)true);
                    this.mEnabledPromise = null;
                }
            } else {
                Log.d((String)"BluetoothSerial", (String)"User did not enable Bluetooth");
                if (this.mEnabledPromise != null) {
                    this.mEnabledPromise.reject((Throwable)new Exception("User did not enable Bluetooth"));
                    this.mEnabledPromise = null;
                }
            }
        }
        if (requestCode == 2) {
            if (resultCode == -1) {
                Log.d((String)"BluetoothSerial", (String)"Pairing ok");
            } else {
                Log.d((String)"BluetoothSerial", (String)"Pairing failed");
            }
        }
    }

    public void onNewIntent(Intent intent) {
        Log.d((String)"BluetoothSerial", (String)"On new intent");
    }

    public void onHostResume() {
        Log.d((String)"BluetoothSerial", (String)"Host resume");
    }

    public void onHostPause() {
        Log.d((String)"BluetoothSerial", (String)"Host pause");
    }

    public void onHostDestroy() {
        Log.d((String)"BluetoothSerial", (String)"Host destroy");
        this.mBluetoothService.stopAll();
    }

    public void onCatalystInstanceDestroy() {
        Log.d((String)"BluetoothSerial", (String)"Catalyst instance destroyed");
        super.onCatalystInstanceDestroy();
        this.mBluetoothService.stopAll();
    }

    @ReactMethod
    public void requestEnable(Promise promise) {
        if (this.mBluetoothAdapter != null) {
            if (this.mBluetoothAdapter.isEnabled()) {
                promise.resolve((Object)true);
            } else {
                Activity activity = this.getCurrentActivity();
                Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
                if (activity != null) {
                    this.mEnabledPromise = promise;
                    activity.startActivityForResult(intent, 1);
                } else {
                    Exception e = new Exception("Cannot start activity");
                    Log.e((String)"BluetoothSerial", (String)"Cannot start activity", (Throwable)e);
                    promise.reject((Throwable)e);
                    this.onError(e);
                }
            }
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void enable(Promise promise) {
        if (this.mBluetoothAdapter != null) {
            if (this.mBluetoothAdapter.isEnabled()) {
                Log.d((String)"BluetoothSerial", (String)"Bluetooth enabled");
                promise.resolve((Object)true);
            } else {
                try {
                    this.mBluetoothAdapter.enable();
                    Log.d((String)"BluetoothSerial", (String)"Bluetooth enabled");
                    promise.resolve((Object)true);
                }
                catch (Exception e) {
                    Log.e((String)"BluetoothSerial", (String)"Cannot enable bluetooth");
                    promise.reject((Throwable)e);
                    this.onError(e);
                }
            }
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void disable(Promise promise) {
        if (this.mBluetoothAdapter != null) {
            if (!this.mBluetoothAdapter.isEnabled()) {
                Log.d((String)"BluetoothSerial", (String)"Bluetooth disabled");
                promise.resolve((Object)true);
            } else {
                try {
                    this.mBluetoothAdapter.disable();
                    Log.d((String)"BluetoothSerial", (String)"Bluetooth disabled");
                    promise.resolve((Object)true);
                }
                catch (Exception e) {
                    Log.e((String)"BluetoothSerial", (String)"Cannot disable bluetooth");
                    promise.reject((Throwable)e);
                    this.onError(e);
                }
            }
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void isEnabled(Promise promise) {
        if (this.mBluetoothAdapter != null) {
            promise.resolve((Object)this.mBluetoothAdapter.isEnabled());
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void list(Promise promise) {
        Log.d((String)"BluetoothSerial", (String)"List paired called");
        if (this.mBluetoothAdapter != null) {
            WritableArray deviceList = Arguments.createArray();
            Set bondedDevices = this.mBluetoothAdapter.getBondedDevices();
            for (BluetoothDevice rawDevice : bondedDevices) {
                WritableMap device = this.deviceToWritableMap(rawDevice);
                deviceList.pushMap(device);
            }
            promise.resolve((Object)deviceList);
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void listUnpaired(Promise promise) {
        Log.d((String)"BluetoothSerial", (String)"Discover unpaired called");
        if (this.mBluetoothAdapter != null) {
            this.mDeviceDiscoveryPromise = promise;
            this.registerBluetoothDeviceDiscoveryReceiver();
            this.mBluetoothAdapter.startDiscovery();
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void cancelDiscovery(Promise promise) {
        Log.d((String)"BluetoothSerial", (String)"Cancel discovery called");
        if (this.mBluetoothAdapter != null) {
            if (this.mBluetoothAdapter.isDiscovering()) {
                this.mBluetoothAdapter.cancelDiscovery();
            }
            promise.resolve((Object)true);
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void pairDevice(String id, Promise promise) {
        Log.d((String)"BluetoothSerial", (String)("Pair device: " + id));
        if (this.mBluetoothAdapter != null) {
            BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(id);
            if (device != null) {
                this.mPairDevicePromise = promise;
                this.pairDevice(device);
            } else {
                promise.reject((Throwable)new Exception("Could not pair device " + id));
            }
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void unpairDevice(String id, Promise promise) {
        Log.d((String)"BluetoothSerial", (String)("Unpair device: " + id));
        if (this.mBluetoothAdapter != null) {
            BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(id);
            if (device != null) {
                this.mPairDevicePromise = promise;
                this.unpairDevice(device);
            } else {
                promise.reject((Throwable)new Exception("Could not unpair device " + id));
            }
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void connect(String id, Promise promise) {
        Log.d((String)"BluetoothSerial", (String)"connect");
        if (this.mBluetoothAdapter != null) {
            BluetoothDevice rawDevice = this.mBluetoothAdapter.getRemoteDevice(id);
            if (rawDevice != null) {
                this.mConnectedPromises.put(id, promise);
                this.mBluetoothService.connect(rawDevice);
            } else {
                this.mConnectedPromises.put(FIRST_DEVICE, promise);
                this.registerFirstAvailableBluetoothDeviceDiscoveryReceiver();
            }
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void disconnect(@Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        Log.d((String)"BluetoothSerial", (String)("Disconnect from device id " + id));
        if (id != null) {
            this.mBluetoothService.stop(id);
        }
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void disconnectAll(Promise promise) {
        this.mBluetoothService.stopAll();
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void isConnected(@Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        if (id == null) {
            promise.resolve((Object)false);
        } else {
            promise.resolve((Object)this.mBluetoothService.isConnected(id));
        }
    }

    @ReactMethod
    public void writeToDevice(String message, @Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        Log.d((String)"BluetoothSerial", (String)("Write to device id " + id + " : " + message));
        if (id != null) {
            byte[] data = Base64.decode((String)message, (int)0);
            this.mBluetoothService.write(id, data);
        }
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void readFromDevice(@Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        Log.d((String)"BluetoothSerial", (String)("Read from device id " + id));
        String data = "";
        if (this.mBuffers.containsKey(id)) {
            StringBuffer buffer = this.mBuffers.get(id);
            int length = buffer.length();
            data = buffer.substring(0, length);
            buffer.delete(0, length);
            this.mBuffers.put(id, buffer);
        }
        promise.resolve((Object)data);
    }

    @ReactMethod
    public void readUntilDelimiter(String delimiter, @Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        promise.resolve((Object)this.readUntil(id, delimiter));
    }

    @ReactMethod
    public void withDelimiter(String delimiter, @Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        Log.d((String)"BluetoothSerial", (String)("Set delimiter of device id " + id + " to " + delimiter));
        if (id != null) {
            this.mDelimiters.put(id, delimiter);
        }
        promise.resolve((Object)id);
    }

    @ReactMethod
    public void clear(@Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        if (this.mBuffers.containsKey(id)) {
            StringBuffer buffer = this.mBuffers.get(id);
            buffer.setLength(0);
            this.mBuffers.put(id, buffer);
        }
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void available(@Nullable String id, Promise promise) {
        if (id == null) {
            id = this.mBluetoothService.getFirstDeviceAddress();
        }
        int length = 0;
        if (this.mBuffers.containsKey(id)) {
            StringBuffer buffer = this.mBuffers.get(id);
            length = buffer.length();
        }
        promise.resolve((Object)length);
    }

    @ReactMethod
    public void setAdapterName(String newName, Promise promise) {
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.setName(newName);
            promise.resolve((Object)this.mBluetoothAdapter.getName());
        } else {
            this.rejectNullBluetoothAdapter(promise);
        }
    }

    @ReactMethod
    public void setServices(ReadableArray services, Boolean includeDefaultServices, Promise promise) {
        WritableArray updated = Arguments.createArray();
        promise.resolve((Object)updated);
    }

    @ReactMethod
    public void getServices(Promise promise) {
        WritableArray services = Arguments.createArray();
        promise.resolve((Object)services);
    }

    @ReactMethod
    public void restoreServices(Promise promise) {
        WritableArray services = Arguments.createArray();
        promise.resolve((Object)services);
    }

    void onConnectionSuccess(String msg, BluetoothDevice connectedDevice) {
        Promise promise;
        String id = connectedDevice.getAddress();
        if (!this.mDelimiters.containsKey(id)) {
            this.mDelimiters.put(id, "");
        }
        if (!this.mBuffers.containsKey(id)) {
            this.mBuffers.put(id, new StringBuffer());
        }
        if (this.mConnectedPromises.containsKey(id) && (promise = this.mConnectedPromises.get(id)) != null) {
            WritableMap deviceForPromise = this.deviceToWritableMap(connectedDevice);
            promise.resolve((Object)deviceForPromise);
        }
        WritableMap device = this.deviceToWritableMap(connectedDevice);
        WritableMap params = Arguments.createMap();
        params.putMap("device", device);
        params.putString("message", msg);
        this.sendEvent(CONN_SUCCESS, params);
    }

    void onConnectionFailed(String msg, BluetoothDevice connectedDevice) {
        Promise promise;
        WritableMap params = Arguments.createMap();
        WritableMap device = this.deviceToWritableMap(connectedDevice);
        params.putMap("device", device);
        params.putString("message", msg);
        String id = connectedDevice.getAddress();
        if (this.mConnectedPromises.containsKey(id) && (promise = this.mConnectedPromises.get(id)) != null) {
            promise.reject((Throwable)new Exception(msg));
        }
        this.sendEvent(CONN_FAILED, params);
    }

    void onConnectionLost(String msg, BluetoothDevice connectedDevice) {
        WritableMap params = Arguments.createMap();
        WritableMap device = this.deviceToWritableMap(connectedDevice);
        params.putMap("device", device);
        params.putString("message", msg);
        this.mConnectedPromises.remove(connectedDevice.getAddress());
        this.sendEvent(CONN_LOST, params);
    }

    void onError(Exception e) {
        WritableMap params = Arguments.createMap();
        params.putString("message", e.getMessage());
        this.sendEvent(ERROR, params);
    }

    void onData(String id, String data) {
        String completeData;
        if (this.mBuffers.containsKey(id)) {
            StringBuffer buffer = this.mBuffers.get(id);
            buffer.append(data);
            this.mBuffers.put(id, buffer);
        }
        String delimiter = "";
        if (this.mDelimiters.containsKey(id)) {
            delimiter = this.mDelimiters.get(id);
        }
        if ((completeData = this.readUntil(id, delimiter)) != null && completeData.length() > 0) {
            WritableMap readParams = Arguments.createMap();
            readParams.putString("id", id);
            readParams.putString(DATA_READ, completeData);
            this.sendEvent(DEVICE_READ, readParams);
            WritableMap dataParams = Arguments.createMap();
            dataParams.putString("id", id);
            dataParams.putString(DATA_READ, completeData);
            this.sendEvent(DATA_READ, dataParams);
        }
    }

    private String readUntil(String id, String delimiter) {
        StringBuffer buffer;
        int index;
        String data = "";
        if (this.mBuffers.containsKey(id) && (index = (buffer = this.mBuffers.get(id)).indexOf(delimiter, 0)) > -1) {
            data = buffer.substring(0, index + delimiter.length());
            buffer.delete(0, index + delimiter.length());
            this.mBuffers.put(id, buffer);
        }
        return data;
    }

    private boolean isKitKatOrAbove() {
        return Build.VERSION.SDK_INT >= 19;
    }

    private void sendEvent(String eventName, @Nullable WritableMap params) {
        if (this.mReactContext.hasActiveCatalystInstance()) {
            Log.d((String)"BluetoothSerial", (String)("Sending event: " + eventName));
            ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.mReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
        }
    }

    private WritableMap deviceToWritableMap(BluetoothDevice device) {
        Log.d((String)"BluetoothSerial", (String)("device" + device.toString()));
        WritableMap params = Arguments.createMap();
        if (device != null) {
            params.putString("name", device.getName());
            params.putString("address", device.getAddress());
            params.putString("id", device.getAddress());
            if (device.getBluetoothClass() != null) {
                params.putInt("class", device.getBluetoothClass().getDeviceClass());
            }
        }
        return params;
    }

    private void pairDevice(BluetoothDevice device) {
        try {
            Log.d((String)"BluetoothSerial", (String)"Start Pairing...");
            Method m = device.getClass().getMethod("createBond", null);
            m.invoke((Object)device, (Object[])null);
            this.registerDevicePairingReceiver(device, 12);
        }
        catch (Exception e) {
            Log.e((String)"BluetoothSerial", (String)"Cannot pair device", (Throwable)e);
            if (this.mPairDevicePromise != null) {
                this.mPairDevicePromise.reject((Throwable)e);
                this.mPairDevicePromise = null;
            }
            this.onError(e);
        }
    }

    private void unpairDevice(BluetoothDevice device) {
        try {
            Log.d((String)"BluetoothSerial", (String)"Start Unpairing...");
            Method m = device.getClass().getMethod("removeBond", null);
            m.invoke((Object)device, (Object[])null);
            this.registerDevicePairingReceiver(device, 10);
        }
        catch (Exception e) {
            Log.e((String)"BluetoothSerial", (String)"Cannot unpair device", (Throwable)e);
            if (this.mPairDevicePromise != null) {
                this.mPairDevicePromise.reject((Throwable)e);
                this.mPairDevicePromise = null;
            }
            this.onError(e);
        }
    }

    private void rejectNullBluetoothAdapter(Promise promise) {
        Exception e = new Exception("Bluetooth adapter not found");
        Log.e((String)"BluetoothSerial", (String)"Bluetooth adapter not found");
        promise.reject((Throwable)e);
        this.onError(e);
    }

    private void registerDevicePairingReceiver(BluetoothDevice rawDevice, int requiredState) {
        final WritableMap device = this.deviceToWritableMap(rawDevice);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        BroadcastReceiver devicePairingReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
                    int state = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                    int prevState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", Integer.MIN_VALUE);
                    if (state == 12 && prevState == 11) {
                        Log.d((String)"BluetoothSerial", (String)"Device paired");
                        if (RCTBluetoothSerialModule.this.mPairDevicePromise != null) {
                            RCTBluetoothSerialModule.this.mPairDevicePromise.resolve((Object)device);
                            RCTBluetoothSerialModule.this.mPairDevicePromise = null;
                        }
                        try {
                            RCTBluetoothSerialModule.this.mReactContext.unregisterReceiver((BroadcastReceiver)this);
                        }
                        catch (Exception e) {
                            Log.e((String)"BluetoothSerial", (String)"Cannot unregister receiver", (Throwable)e);
                            RCTBluetoothSerialModule.this.onError(e);
                        }
                    } else if (state == 10 && prevState == 12) {
                        Log.d((String)"BluetoothSerial", (String)"Device unpaired");
                        if (RCTBluetoothSerialModule.this.mPairDevicePromise != null) {
                            RCTBluetoothSerialModule.this.mPairDevicePromise.resolve((Object)device);
                            RCTBluetoothSerialModule.this.mPairDevicePromise = null;
                        }
                        try {
                            RCTBluetoothSerialModule.this.mReactContext.unregisterReceiver((BroadcastReceiver)this);
                        }
                        catch (Exception e) {
                            Log.e((String)"BluetoothSerial", (String)"Cannot unregister receiver", (Throwable)e);
                            RCTBluetoothSerialModule.this.onError(e);
                        }
                    }
                }
            }
        };
        this.mReactContext.registerReceiver(devicePairingReceiver, intentFilter);
    }

    private void registerBluetoothDeviceDiscoveryReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.device.action.FOUND");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        BroadcastReceiver deviceDiscoveryReceiver = new BroadcastReceiver(){
            private WritableArray unpairedDevices = Arguments.createArray();

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                Log.d((String)"BluetoothSerial", (String)"onReceive called");
                if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(action)) {
                    Log.d((String)"BluetoothSerial", (String)"Discovery started");
                } else if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice rawDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Log.d((String)"BluetoothSerial", (String)("Discovery extra device (device id: " + rawDevice.getAddress() + ")"));
                    WritableMap device = RCTBluetoothSerialModule.this.deviceToWritableMap(rawDevice);
                    this.unpairedDevices.pushMap(device);
                } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                    Log.d((String)"BluetoothSerial", (String)"Discovery finished");
                    if (RCTBluetoothSerialModule.this.mDeviceDiscoveryPromise != null) {
                        RCTBluetoothSerialModule.this.mDeviceDiscoveryPromise.resolve((Object)this.unpairedDevices);
                        RCTBluetoothSerialModule.this.mDeviceDiscoveryPromise = null;
                    }
                    try {
                        RCTBluetoothSerialModule.this.mReactContext.unregisterReceiver((BroadcastReceiver)this);
                    }
                    catch (Exception e) {
                        Log.e((String)"BluetoothSerial", (String)"Unable to unregister receiver", (Throwable)e);
                        RCTBluetoothSerialModule.this.onError(e);
                    }
                }
            }
        };
        this.mReactContext.registerReceiver(deviceDiscoveryReceiver, intentFilter);
    }

    private void registerFirstAvailableBluetoothDeviceDiscoveryReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.device.action.FOUND");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        BroadcastReceiver deviceDiscoveryReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                Log.d((String)"BluetoothSerial", (String)"onReceive called");
                if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(action)) {
                    Log.d((String)"BluetoothSerial", (String)"Discovery started");
                } else if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice rawDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    String id = rawDevice.getAddress();
                    Log.d((String)"BluetoothSerial", (String)("Discovery first available device (device id: " + id + ")"));
                    RCTBluetoothSerialModule.this.mBluetoothService.connect(rawDevice);
                    if (RCTBluetoothSerialModule.this.mConnectedPromises.containsKey(RCTBluetoothSerialModule.FIRST_DEVICE)) {
                        Promise promise = (Promise)RCTBluetoothSerialModule.this.mConnectedPromises.get(RCTBluetoothSerialModule.FIRST_DEVICE);
                        RCTBluetoothSerialModule.this.mConnectedPromises.remove(RCTBluetoothSerialModule.FIRST_DEVICE);
                        RCTBluetoothSerialModule.this.mConnectedPromises.put(id, promise);
                        if (promise != null) {
                            WritableMap device = RCTBluetoothSerialModule.this.deviceToWritableMap(rawDevice);
                            promise.resolve((Object)device);
                        }
                    }
                    try {
                        RCTBluetoothSerialModule.this.mReactContext.unregisterReceiver((BroadcastReceiver)this);
                    }
                    catch (Exception e) {
                        Log.e((String)"BluetoothSerial", (String)"Unable to unregister receiver", (Throwable)e);
                        RCTBluetoothSerialModule.this.onError(e);
                    }
                }
            }
        };
        this.mReactContext.registerReceiver(deviceDiscoveryReceiver, intentFilter);
    }

    private void registerBluetoothStateReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        BroadcastReceiver bluetoothStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
                    int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    switch (state) {
                        case 10: {
                            Log.d((String)"BluetoothSerial", (String)"Bluetooth was disabled");
                            RCTBluetoothSerialModule.this.sendEvent(RCTBluetoothSerialModule.BT_DISABLED, null);
                            break;
                        }
                        case 12: {
                            Log.d((String)"BluetoothSerial", (String)"Bluetooth was enabled");
                            RCTBluetoothSerialModule.this.sendEvent(RCTBluetoothSerialModule.BT_ENABLED, null);
                            break;
                        }
                    }
                }
            }
        };
        this.mReactContext.registerReceiver(bluetoothStateReceiver, intentFilter);
    }
}

