/*
 * Decompiled with CFR 0.152.
 */
package com.nuttawutmalee.RCTBluetoothSerial;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Build;
import android.util.Log;
import com.nuttawutmalee.RCTBluetoothSerial.RCTBluetoothSerialModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

class RCTBluetoothSerialService {
    private static final boolean D = true;
    private static final UUID UUID_SPP = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private RCTBluetoothSerialModule mModule;
    private String mFirstDeviceAddress = null;
    private HashMap<String, ConnectThread> mConnectThreads;
    private HashMap<String, ConnectedThread> mConnectedThreads;
    private HashMap<String, String> mStates;
    private static final String STATE_NONE = "none";
    private static final String STATE_CONNECTING = "connecting";
    private static final String STATE_CONNECTED = "connected";

    RCTBluetoothSerialService(RCTBluetoothSerialModule module) {
        this.mModule = module;
        if (this.mConnectThreads == null) {
            this.mConnectThreads = new HashMap();
        }
        if (this.mConnectedThreads == null) {
            this.mConnectedThreads = new HashMap();
        }
        if (this.mStates == null) {
            this.mStates = new HashMap();
        }
    }

    public String getFirstDeviceAddress() {
        return this.mFirstDeviceAddress;
    }

    synchronized void connect(BluetoothDevice device) {
        Log.d((String)"BluetoothSerial", (String)("connect to: " + device));
        String id = device.getAddress();
        this.cancelConnectThread(id);
        this.cancelConnectedThread(id);
        ConnectThread thread = new ConnectThread(device);
        thread.start();
        if (this.mConnectedThreads.isEmpty()) {
            this.mFirstDeviceAddress = id;
        }
        this.mConnectThreads.put(id, thread);
        this.mStates.put(id, STATE_CONNECTING);
    }

    boolean isConnected(String id) {
        return this.mStates.containsKey(id) && this.getState(id).equals(STATE_CONNECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(String id, byte[] out) {
        Log.d((String)"BluetoothSerial", (String)("Write in service of device id " + id + ", state is " + STATE_CONNECTED));
        ConnectedThread r = null;
        RCTBluetoothSerialService rCTBluetoothSerialService = this;
        synchronized (rCTBluetoothSerialService) {
            if (!this.isConnected(id)) {
                return;
            }
            if (this.mConnectedThreads.containsKey(id)) {
                r = this.mConnectedThreads.get(id);
            }
        }
        if (r != null) {
            r.write(out);
        } else {
            Log.e((String)"BluetoothSerial", (String)"Unable to write, connected thread is null");
            this.mModule.onError(new Exception("Unable to write, connected thread is null"));
        }
    }

    synchronized void stop(String id) {
        Log.d((String)"BluetoothSerial", (String)("Stop device id " + id));
        this.cancelConnectThread(id);
        this.cancelConnectedThread(id);
        this.mStates.put(id, STATE_NONE);
        if (id == this.mFirstDeviceAddress) {
            this.mFirstDeviceAddress = null;
        }
    }

    synchronized void stopAll() {
        Thread thread;
        Log.d((String)"BluetoothSerial", (String)"Stop all devices");
        for (Map.Entry<String, ConnectThread> entry : this.mConnectThreads.entrySet()) {
            thread = this.mConnectThreads.get(entry.getKey());
            if (thread == null) continue;
            ((ConnectThread)thread).cancel();
        }
        this.mConnectThreads.clear();
        for (Map.Entry<String, Thread> entry : this.mConnectedThreads.entrySet()) {
            thread = this.mConnectedThreads.get(entry.getKey());
            if (thread == null) continue;
            ((ConnectedThread)thread).cancel();
        }
        this.mConnectedThreads.clear();
        for (Map.Entry<String, Object> entry : this.mStates.entrySet()) {
            this.mStates.put(entry.getKey(), STATE_NONE);
        }
        this.mFirstDeviceAddress = null;
    }

    private synchronized String getState(String id) {
        return this.mStates.get(id);
    }

    private synchronized void connectionSuccess(BluetoothSocket socket, BluetoothDevice device) {
        String id = device.getAddress();
        Log.d((String)"BluetoothSerial", (String)("Connected to device id " + id));
        this.cancelConnectThread(id);
        this.cancelConnectedThread(id);
        ConnectedThread thread = new ConnectedThread(socket, device);
        thread.start();
        this.mConnectedThreads.put(id, thread);
        this.mModule.onConnectionSuccess("Connected to " + device.getName(), device);
        if (this.mStates.containsKey(id)) {
            String oldState = this.mStates.get(id);
            Log.d((String)"BluetoothSerial", (String)("Device id " + id + " setState() " + oldState + " -> " + STATE_CONNECTED));
            this.mStates.put(id, STATE_CONNECTED);
        }
    }

    private void connectionFailed(BluetoothDevice device) {
        this.mModule.onConnectionFailed("Unable to connect to device", device);
        this.stop(device.getAddress());
    }

    private void connectionLost(BluetoothDevice device) {
        this.mModule.onConnectionLost("Device connection was lost", device);
        this.stop(device.getAddress());
    }

    private void cancelConnectThread(String id) {
        ConnectThread thread;
        if (this.mConnectThreads.containsKey(id) && (thread = this.mConnectThreads.get(id)) != null) {
            thread.cancel();
            this.mConnectThreads.remove(id);
        }
    }

    private void cancelConnectedThread(String id) {
        ConnectedThread thread;
        if (this.mConnectedThreads.containsKey(id) && (thread = this.mConnectedThreads.get(id)) != null) {
            thread.cancel();
            this.mConnectedThreads.remove(id);
        }
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final BluetoothDevice mmDevice;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        ConnectedThread(BluetoothSocket socket, BluetoothDevice device) {
            Log.d((String)"BluetoothSerial", (String)"Create ConnectedThread");
            this.mmSocket = socket;
            this.mmDevice = device;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"temp sockets not created", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            Log.i((String)"BluetoothSerial", (String)"Begin mConnectedThread");
            byte[] buffer = new byte[1024];
            String id = this.mmDevice.getAddress();
            try {
                while (true) {
                    int bytes = this.mmInStream.read(buffer);
                    String data = new String(buffer, 0, bytes, "ISO-8859-1");
                    RCTBluetoothSerialService.this.mModule.onData(id, data);
                }
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"disconnected", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
                RCTBluetoothSerialService.this.connectionLost(this.mmDevice);
                return;
            }
        }

        void write(byte[] buffer) {
            try {
                String str = new String(buffer, "UTF-8");
                Log.d((String)"BluetoothSerial", (String)("Write in thread " + str));
                this.mmOutStream.write(buffer);
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"Exception during write", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
            }
        }

        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"close() of connect socket failed", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private BluetoothSocket mmSocket;
        private final BluetoothDevice mmDevice;

        ConnectThread(BluetoothDevice device) {
            Log.d((String)"BluetoothSerial", (String)"Create ConnectThread");
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            try {
                tmp = device.createRfcommSocketToServiceRecord(UUID_SPP);
            }
            catch (Exception e) {
                RCTBluetoothSerialService.this.mModule.onError(e);
                Log.e((String)"BluetoothSerial", (String)"Socket create() failed", (Throwable)e);
            }
            this.mmSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.d((String)"BluetoothSerial", (String)"Begin mConnectThread");
            this.setName("ConnectThread");
            RCTBluetoothSerialService.this.mAdapter.cancelDiscovery();
            try {
                Log.d((String)"BluetoothSerial", (String)"Connecting to socket...");
                this.mmSocket.connect();
                Log.d((String)"BluetoothSerial", (String)"Connected");
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)e.toString());
                RCTBluetoothSerialService.this.mModule.onError(e);
                try {
                    Log.i((String)"BluetoothSerial", (String)"Trying fallback...");
                    this.mmSocket = (BluetoothSocket)this.mmDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE).invoke((Object)this.mmDevice, 1);
                    this.mmSocket.connect();
                    Log.i((String)"BluetoothSerial", (String)"Connected");
                }
                catch (Exception e2) {
                    Log.e((String)"BluetoothSerial", (String)e.toString());
                    RCTBluetoothSerialService.this.mModule.onError(e);
                    try {
                        Log.i((String)"BluetoothSerial", (String)"Trying fallback to insecure socket...");
                        this.mmSocket = this.createInsecureBluetoothSocket(this.mmDevice);
                        this.mmSocket.connect();
                    }
                    catch (Exception e3) {
                        Log.e((String)"BluetoothSerial", (String)"Couldn't establish a Bluetooth connection.");
                        RCTBluetoothSerialService.this.mModule.onError(e3);
                        try {
                            this.mmSocket.close();
                        }
                        catch (Exception e4) {
                            Log.e((String)"BluetoothSerial", (String)"unable to close() socket during connection failure", (Throwable)e3);
                            RCTBluetoothSerialService.this.mModule.onError(e4);
                        }
                        RCTBluetoothSerialService.this.connectionFailed(this.mmDevice);
                        return;
                    }
                }
            }
            RCTBluetoothSerialService rCTBluetoothSerialService = RCTBluetoothSerialService.this;
            synchronized (rCTBluetoothSerialService) {
                RCTBluetoothSerialService.this.mConnectThreads.remove(this.mmDevice.getAddress());
            }
            RCTBluetoothSerialService.this.connectionSuccess(this.mmSocket, this.mmDevice);
        }

        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"close() of connect socket failed", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
            }
        }

        private BluetoothSocket createInsecureBluetoothSocket(BluetoothDevice device) throws IOException {
            if (Build.VERSION.SDK_INT >= 10) {
                try {
                    Method m = device.getClass().getMethod("createInsecureRfcommSocketToServiceRecord", UUID.class);
                    return (BluetoothSocket)m.invoke((Object)device, UUID_SPP);
                }
                catch (Exception e) {
                    Log.e((String)"BluetoothSerial", (String)"Could not create Insecure RFComm Connection", (Throwable)e);
                }
            }
            return device.createRfcommSocketToServiceRecord(UUID_SPP);
        }
    }
}

