/*
 
 Created by Nuttawut Malee on 10.11.18.
 Copyright © 2016 Nuttawut Malee. All rights reserved.
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

#import <React/RCTBridgeModule.h>
#import <React/RCTEventEmitter.h>
#import "BLE.h"
#import "EADSessionController.h"

#import <ExternalAccessory/ExternalAccessory.h>

typedef void (^RCTBluetoothSerialPeripheralCallback) (CBPeripheral *_Nullable peripheral);

/*!
 * RCTBluetoothSerial is an abstract base class to be used for module that connect,
 * read and write data from active peripheral.
 */
@interface RCTBluetoothSerial : RCTEventEmitter <RCTBridgeModule, BLEDelegate, EAAccessoryDelegate>

/*!
 * BLE central manager, for scanning and connection events.
 */
@property (strong, nonatomic, readonly) BLE *ble;

/*!
 * Indicates if there are at least one listeners from RCTEventEmitter.
 */
@property (assign, nonatomic) BOOL doesHaveListeners;

/*!
 * Dictionary of buffer from each active peripherals read value.
 */
@property (strong, nonatomic) NSMutableDictionary *buffers;

/*!
 * Dictionary of certain delimiter to indicate the end of sliced buffer.
 */
@property (strong, nonatomic) NSMutableDictionary *delimiters;

/*!
 * Resolvers an rejectors for connection related function.
 */
@property (strong, nonatomic) NSMutableDictionary *connectionPromises;

/**
 *  @method bluetoothPowerStateTimer
 *
 *  @param timer
 *
 *  @discussion Indicates central manager power state.
 *
 */
- (void)bluetoothPowerStateTimer:(NSTimer *)timer;

@property (strong, nonatomic) NSMutableArray *accessoryList;

@property(nonatomic,retain)EADSessionController *glucoseEADSessionController;

@end
